<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class vBDownloads_DataManager_Download extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'downloadid' 		=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'userid' 			=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'title' 			=> array(TYPE_STR, 		REQ_YES),
		'description' 		=> array(TYPE_STR, 		REQ_NO),
		'totaldownloads' 	=> array(TYPE_UINT, 	REQ_NO),
		'numfiles' 			=> array(TYPE_UINT, 	REQ_YES),
		'image' 			=> array(TYPE_STR, 		REQ_NO),
		'rating' 			=> array(TYPE_UINT, 	REQ_NO),
		'updated' 			=> array(TYPE_UNIXTIME, REQ_AUTO),
		'categoryid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'moderation' 		=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD, 	'verify_offon'),
		'password' 			=> array(TYPE_STR, 		REQ_NO),
		'private' 			=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
		'numfavourites' 	=> array(TYPE_UINT, 	REQ_NO),
		'mirrors' 			=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_downloads_download';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('downloadid = \'%1$s\'', 'downloadid');


	/**
	* Verifies that the specified user exists
	*
	* @param	integer	User ID
	*
	* @return 	boolean	Returns true if user exists
	*/
	function verify_userid(&$userid)
	{
		return $this->info['is_automated'] ? true : parent::verify_userid($userid);
	}

	/**
	* Verifies that the categoryid is valid
	*
	* @param	string	categoryid
	*
	* @return	boolean
	*/
	function verify_categoryid(&$categoryid)
	{
		// Validate categoryid
		return is_array(VBDOWNLOADS::$cache['category'][$categoryid]);
	}

	/**
	* Verifies that the offon flag is valid
	*
	* @param	string	Off/On flag
	*
	* @return	boolean
	*/
	function verify_offon(&$offon)
	{
		// Validate offon
		$offon = (!in_array($offon, array(0, 1)) ? 0 : $offon);
		
		return true;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}

		if (($this->condition !== null AND $this->fetch_field('numfiles') != $this->existing['numfiles']) OR !$this->fetch_field('updated'))
		{
			// Set updated
			$timenow = TIMENOW;
			$this->do_set('updated', $timenow);
		}

		if ($this->condition === null AND VBDOWNLOADS::$cache['category'][$this->fetch_field('categoryid')]['moderation'])
		{
			// Set moderation
			$moderation = 1;
			$this->do_set('moderation', $moderation);
		}
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_downloaddata_presave')) ? eval($hook) : false;		
		
		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_downloaddata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_downloaddata_postsave')) ? eval($hook) : false;

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_downloads_downloaddata_delete')) ? eval($hook) : false;
		
		// Remove comments
		$commentList = VBDOWNLOADS::$db->fetchAll('
			SELECT *
			FROM $dbtech_downloads_comment
			WHERE downloadid = ?
		', array(
			$this->existing['downloadid'],
		));
		foreach ($commentList as $comment)
		{
			// Update the comment
			$dm =& VBDOWNLOADS::initDataManager('Comment', $this->registry, ERRTYPE_SILENT);
				$dm->set_existing($comment);
			$dm->delete();
			unset($dm);
		}
		
		// Remove files
		$fileList = VBDOWNLOADS::$db->fetchAll('
			SELECT *
			FROM $dbtech_downloads_file
			WHERE downloadid = ?
		', array(
			$this->existing['downloadid'],
		));
		foreach ($fileList as $file)
		{
			// Update the file
			$dm =& VBDOWNLOADS::initDataManager('File', $this->registry, ERRTYPE_SILENT);
				$dm->set_existing($file);
			$dm->delete();
			unset($dm);
		}
		
		return true;
	}
}